/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.physical.humanoid;

import com.badlogic.gdx.graphics.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import technology.rocketjump.undermount.assets.entities.humanoid.model.HumanoidBodyType;
import technology.rocketjump.undermount.assets.entities.model.ColoringLayer;
import technology.rocketjump.undermount.entities.model.physical.EntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.humanoid.Gender;
import technology.rocketjump.undermount.entities.model.physical.humanoid.HumanoidName;
import technology.rocketjump.undermount.entities.model.physical.humanoid.Race;

public class HumanoidEntityAttributes
implements EntityAttributes {
    private final long seed;
    private Race race;
    private Gender gender;
    private HumanoidBodyType bodyType;
    private Color skinColor;
    private Color hairColor;
    private Color eyeColor;
    private Color accessoryColor;
    private boolean hasHair;
    private HumanoidName name;
    List<HumanoidBodyType> bodyTypesToPickFrom = Arrays.asList(HumanoidBodyType.AVERAGE, HumanoidBodyType.FAT, HumanoidBodyType.STRONG);

    public HumanoidEntityAttributes(long seed, Color hairColor, Color skinColor, Color accessoryColor) {
        this.seed = seed;
        this.race = Race.DWARF;
        Random random = new Random(seed);
        this.gender = random.nextBoolean() ? Gender.MALE : Gender.FEMALE;
        this.bodyType = this.bodyTypesToPickFrom.get(random.nextInt(this.bodyTypesToPickFrom.size()));
        this.hairColor = hairColor;
        this.skinColor = skinColor;
        this.eyeColor = Color.BLACK;
        this.hasHair = true;
        this.accessoryColor = accessoryColor;
    }

    @Override
    public HumanoidEntityAttributes clone() {
        HumanoidEntityAttributes cloned = new HumanoidEntityAttributes(this.seed, this.hairColor.cpy(), this.skinColor.cpy(), this.accessoryColor.cpy());
        cloned.race = this.race;
        cloned.gender = this.gender;
        cloned.bodyType = this.bodyType;
        cloned.hasHair = this.hasHair;
        return cloned;
    }

    public Race getRace() {
        return this.race;
    }

    public void setRace(Race race) {
        this.race = race;
    }

    public HumanoidBodyType getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(HumanoidBodyType bodyType) {
        this.bodyType = bodyType;
    }

    public void setSkinColor(Color skinColor) {
        this.skinColor = skinColor;
    }

    public void setHairColor(Color hairColor) {
        this.hairColor = hairColor;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public Color getColor(ColoringLayer coloringLayer) {
        switch (coloringLayer) {
            case EYE_COLOR: {
                return this.eyeColor;
            }
            case HAIR_COLOR: {
                return this.hairColor;
            }
            case SKIN_COLOR: {
                return this.skinColor;
            }
            case ACCESSORY_COLOR: {
                return this.accessoryColor;
            }
        }
        return null;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setAccessoryColor(Color accessoryColor) {
        this.accessoryColor = accessoryColor;
    }

    public boolean getHasHair() {
        return this.hasHair;
    }

    public void setHasHair(boolean hasHair) {
        this.hasHair = hasHair;
    }

    public void setName(HumanoidName name) {
        this.name = name;
    }

    public HumanoidName getName() {
        return this.name;
    }
}

